/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Screen;
import org.microemu.device.DeviceFactory;

public abstract class Item {
    static final int OUTOFITEM = Integer.MAX_VALUE;
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_TOP = 16;
    public static final int LAYOUT_BOTTOM = 32;
    public static final int LAYOUT_VCENTER = 48;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    public static final int LAYOUT_SHRINK = 1024;
    public static final int LAYOUT_EXPAND = 2048;
    public static final int LAYOUT_VSHRINK = 4096;
    public static final int LAYOUT_VEXPAND = 8192;
    public static final int LAYOUT_2 = 16384;
    public static final int PLAIN = 0;
    public static final int HYPERLINK = 1;
    public static final int BUTTON = 2;
    w labelComponent;
    public Screen owner = null;
    private boolean focus = false;
    int layout;
    Vector commands;
    Command defaultCommand;
    ItemCommandListener commandListener;
    private int prefWidth;
    private int prefHeight;

    public Item(String string) {
        this.labelComponent = new w(string);
        this.commands = new Vector();
    }

    public void addCommand(Command command) {
        if (command == null) {
            throw new NullPointerException();
        }
        if (!this.commands.contains(command)) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.commands.size(); ++i2) {
                if (command.getPriority() >= ((Command)this.commands.elementAt(i2)).getPriority()) continue;
                this.commands.insertElementAt(command, i2);
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.commands.addElement(command);
            }
            this.repaintOwner();
        }
    }

    public String getLabel() {
        w w2 = this.labelComponent;
        return w2.a;
    }

    public int getLayout() {
        return this.layout;
    }

    public int getMinimumHeight() {
        if (this.labelComponent != null) {
            return this.labelComponent.b();
        }
        return 0;
    }

    public int getMinimumWidth() {
        return this.getMaximumWidth();
    }

    public int getPreferredHeight() {
        int n2 = this.prefHeight;
        int n3 = this.getMinimumHeight();
        int n4 = this.getMaximumHeight();
        if (n2 == -1) {
            return n3;
        }
        if (n2 < n3) {
            n2 = n3;
        } else if (n2 > n4) {
            n2 = n4;
        }
        return n2;
    }

    public int getPreferredWidth() {
        int n2 = this.prefWidth;
        int n3 = this.getMinimumWidth();
        int n4 = this.getMaximumWidth();
        if (n2 == -1) {
            return n4;
        }
        if (n2 < n3) {
            n2 = n3;
        } else if (n2 > n4) {
            n2 = n4;
        }
        return n2;
    }

    public void notifyStateChanged() {
        Screen screen = this.getOwner();
        if (screen != null && screen instanceof Form) {
            screen = (Form)screen;
            ((Form)screen).fireItemStateListener(this);
        }
    }

    public void removeCommand(Command command) {
        this.commands.removeElement(command);
        if (this.defaultCommand == command) {
            this.defaultCommand = null;
        }
        this.repaintOwner();
    }

    public void setDefaultCommand(Command command) {
        this.defaultCommand = command;
        if (command != null) {
            if (this.commands.contains(command)) {
                this.addCommand(command);
                return;
            }
            this.repaintOwner();
            return;
        }
        this.repaintOwner();
    }

    public void setItemCommandListener(ItemCommandListener itemCommandListener) {
        this.commandListener = itemCommandListener;
    }

    public void setLabel(String string) {
        this.labelComponent.a(string);
        this.repaint();
    }

    public void setLayout(int n2) {
        if ((n2 & 0x400) != 0 && (n2 & 0x800) != 0 || (n2 & 0x1000) != 0 && (n2 & 0x2000) != 0) {
            throw new IllegalArgumentException("Bad combination of layout policies");
        }
        this.layout = n2;
        this.repaint();
    }

    public void setPreferredSize(int n2, int n3) {
        if (n2 < -1 || n3 < -1) {
            throw new IllegalArgumentException();
        }
        this.prefWidth = n2;
        this.prefHeight = n3;
        this.repaint();
    }

    void repaintOwner() {
        Screen screen = this.getOwner();
        if (screen != null) {
            screen.repaint();
        }
    }

    protected int getHeight() {
        return this.labelComponent.b();
    }

    boolean isFocusable() {
        return false;
    }

    void keyPressed(int n2) {
    }

    protected abstract int paint(Graphics var1);

    void paintContent(Graphics graphics) {
        this.labelComponent.a(graphics);
    }

    public void repaint() {
        if (this.owner != null) {
            this.owner.repaint();
        }
    }

    boolean hasFocus() {
        return this.focus;
    }

    void setFocus(boolean bl2) {
        this.focus = bl2;
    }

    public Screen getOwner() {
        return this.owner;
    }

    void setOwner(Screen screen) {
        this.owner = screen;
        if (screen == null) {
            this.setFocus(false);
        }
    }

    boolean select() {
        if (this.defaultCommand != null && this.commandListener != null) {
            this.commandListener.commandAction(this.defaultCommand, this);
            return true;
        }
        return false;
    }

    int traverse(int n2, int n3, int n4, boolean bl2) {
        return 0;
    }

    int getMaximumHeight() {
        if (this.owner != null) {
            return this.owner.getHeight() * 10;
        }
        return DeviceFactory.getDevice().getDeviceDisplay().getHeight() * 10;
    }

    int getMaximumWidth() {
        if (this.owner != null) {
            return this.owner.getWidth() - 3;
        }
        return DeviceFactory.getDevice().getDeviceDisplay().getWidth() - 3;
    }

    public ItemCommandListener getItemCommandListener() {
        return this.commandListener;
    }
}

